local t = Def.ActorFrame {};
	
t[#t+1] = Def.Quad {
		InitCommand=cmd(horizalign,left;vertalign,top;x,0;y,0;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color("#B8BFE7"););
		OffCommand=cmd(decelerate,0.6;diffusealpha,0;addy,30);
	};

if GAMESTATE:IsCourseMode() == false then

t[#t+1] = Def.Sprite {
		name="SongBG";
        InitCommand=cmd(scaletoclipped,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-16;playcommand,"Set";); 
		OnCommand=cmd(diffusealpha,0;addy,-30;sleep,0.4;decelerate,1.1;diffusealpha,1;addy,30;);
		OffCommand=cmd(decelerate,0.6;diffusealpha,0;addy,30);
        SetCommand=function(self) 
            local song = GAMESTATE:GetCurrentSong(); 
			if song then
                if song:HasBackground() then
                    self:Load(song:GetBackgroundPath())
                else
                    self:Load(THEME:GetPathG("Common fallback", "background"))
                end
			else
				self:diffusealpha(0)
            end
        end;
		};	
end;

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-50;diffuse,color("#FFFFFF");zoom,0.6;visible,not GAMESTATE:IsCourseMode();); 
		  BeginCommand=cmd(playcommand,"Set");
		  OnCommand=cmd(addx,-10;diffusealpha,0;sleep,0.6;smooth,0.4;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then 
                    self:settext(song:GetDisplayFullTitle()); 
                    self:playcommand("Refresh");
				else
					self:settext("");
					self:playcommand("Refresh"); 
               end 
          end;
};
	
-- New shaders
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(horizalign,left;vertalign,top;x,SCREEN_LEFT;y,SCREEN_TOP;visible,GAMESTATE:IsHumanPlayer(PLAYER_1););
	OnCommand=cmd(addx,-269;decelerate,0.6;addx,269);
	OffCommand=cmd(sleep,0.4;decelerate,0.4;addx,-269);
		Def.Quad {
			InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);horizalign,left;vertalign,top;zoomto,9,SCREEN_HEIGHT;addx,260;diffuse,color("#000000");faderight,1.0;diffusealpha,0.2)
		};
		Def.Quad {
			InitCommand=cmd(horizalign,left;vertalign,top;zoomto,260,SCREEN_HEIGHT;diffuse,color("#FFFFFF");diffusealpha,0.8)
		};
	};
	
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);horizalign,right;vertalign,top;x,SCREEN_RIGHT;y,SCREEN_TOP;visible,GAMESTATE:IsHumanPlayer(PLAYER_2););
	OnCommand=cmd(addx,269;decelerate,0.6;addx,-269);
	OffCommand=cmd(sleep,0.4;decelerate,0.4;addx,269);
		Def.Quad {
			InitCommand=cmd(horizalign,right;vertalign,top;zoomto,9,SCREEN_HEIGHT;addx,-260;diffuse,color("#000000");fadeleft,1.0;diffusealpha,0.2)
		};
		Def.Quad {
			InitCommand=cmd(horizalign,right;vertalign,top;zoomto,260,SCREEN_HEIGHT;diffuse,color("#FFFFFF");diffusealpha,0.8)
		};
	};	
	
t[#t+1] = LoadActor("labels") .. {
		InitCommand=cmd(diffusealpha,1;addx,-80;);
	};
t[#t+1] = LoadActor("p2labels") .. {
		InitCommand=cmd(diffusealpha,1;addx,80;);
	};

-- P1 Grade Circle
t[#t+1] = LoadActor("_gradecircle") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);zoom,0.6;x,SCREEN_LEFT+210-80;y,SCREEN_CENTER_Y-120;playcommand,"Set";);
		OnCommand=cmd(diffusealpha,0;sleep,0.3;decelerate,0.3;diffusealpha,1;zoom,0.65;accelerate,0.2;zoom,0.6;sleep,1;);
		OffCommand=cmd(sleep,0.2;decelerate,0.1;zoom,0.7;accelerate,0.2;zoom,0);
		SetCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W3') == true) then
					self:diffuse(color("#6B9638"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#FFEB3B"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#B3E5FC"))
		end
	end;	
};

-- P2 Grade Circle
t[#t+1] = LoadActor("_gradecircle") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoom,0.6;x,SCREEN_RIGHT-210+80;y,SCREEN_CENTER_Y-120;playcommand,"Set";);
		OnCommand=cmd(diffusealpha,0;sleep,0.3;decelerate,0.3;diffusealpha,1;zoom,0.65;accelerate,0.2;zoom,0.6;sleep,1;);
		OffCommand=cmd(sleep,0.2;decelerate,0.1;zoom,0.7;accelerate,0.2;zoom,0);
		SetCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W3') == true) then
					self:diffuse(color("#6B9638"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#FFEB3B"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#B3E5FC"))
		end
	end;	
};

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
          InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);x,SCREEN_LEFT+98-80;y,SCREEN_TOP+193;horizalign,left;diffuse,color("#212121");zoom,0.6;uppercase,true;playcommand,"Set";);
		  OnCommand=cmd(diffusealpha,0;addx,-10;sleep,0.5;decelerate,0.2;diffusealpha,1;addx,10;);	
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          SetCommand=function(self)
			stepsP1 = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPlayedSteps()[1]
				if stepsP1 ~= nil then
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString( stepsP1:GetDifficulty())));
				else
					self:settext("")
				end
          end
};

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
          InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);x,SCREEN_RIGHT-98+80;y,SCREEN_TOP+193;horizalign,right;diffuse,color("#212121");zoom,0.6;uppercase,true;playcommand,"Set";);
		  OnCommand=cmd(diffusealpha,0;addx,10;sleep,0.5;decelerate,0.2;diffusealpha,1;addx,-10;);	
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          SetCommand=function(self)
			stepsP1 = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPlayedSteps()[1]
				if stepsP1 ~= nil then
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString( stepsP1:GetDifficulty())));
				else
					self:settext("")
				end
          end
};
		
t[#t+1] = Def.Sprite {
		name="CourseBanner";
        InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-120;visible,GAMESTATE:IsCourseMode();playcommand,"Set";); 
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0.8;);
		OnCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1);
		TransitionCommand=cmd(finishtweening;zoomx,0.0;diffusealpha,0;decelerate,0.5;zoom,1;diffusealpha,1;); 
        SetCommand=function(self) 
            local course = GAMESTATE:GetCurrentCourse(); 
			if course then
                if course:HasBanner() then
                    self:Load(course:GetBannerPath())
					self:playcommand("Transition")
                    self:scaletoclipped(220,69)
                else
                    self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(128,128)
					self:playcommand("Transition")
                end
			else
				self:diffusealpha(0)
            end
        end;
		};
		
return t